/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.data.tag.SlashBladeEntityTypeTagProvider;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.event.InputCommandEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.InputCommand;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TargetSelector {
    public static final TargetingConditions lockon = new SlashBladeTargetingConditions().m_26883_(12.0).m_26888_((Predicate)new AttackablePredicate());
    public static final TargetingConditions test = new SlashBladeTargetingConditions().m_26888_(new AttackablePredicate());
    static final String AttackableTag = "RevengeAttacker";
    public static final TargetingConditions areaAttack = new SlashBladeTargetingConditions().m_26883_(12.0).m_26893_().m_26888_((Predicate)new AttackablePredicate());

    static boolean isAttackable(Entity revengeTarget, Entity attacker) {
        return revengeTarget != null && attacker != null && (revengeTarget == attacker || revengeTarget.m_7307_(attacker));
    }

    public static TargetingConditions getAreaAttackPredicate(double reach) {
        return areaAttack.m_26883_(reach);
    }

    public static List<Entity> getReflectableEntitiesWithinAABB(LivingEntity attacker) {
        double reach = TargetSelector.getResolvedReach(attacker);
        AABB aabb = TargetSelector.getResolvedAxisAligned(attacker.m_20191_(), attacker.m_20154_(), reach);
        Level world = attacker.m_9236_();
        return Stream.of(world.m_45976_(Projectile.class, aabb).stream().filter(e -> !(e.m_19749_() != null && e.m_19749_() == attacker || e instanceof IShootable && ((IShootable)e).getShooter() == attacker))).flatMap(s -> s).filter(e -> e.m_20280_((Entity)attacker) < reach * reach).collect(Collectors.toList());
    }

    public static List<Entity> getExtinguishableEntitiesWithinAABB(LivingEntity attacker) {
        double reach = TargetSelector.getResolvedReach(attacker);
        AABB aabb = TargetSelector.getResolvedAxisAligned(attacker.m_20191_(), attacker.m_20154_(), reach);
        Level world = attacker.m_9236_();
        return world.m_45976_(PrimedTnt.class, aabb).stream().filter(e -> e.m_20280_((Entity)attacker) < reach * reach).collect(Collectors.toList());
    }

    public static List<Entity> getTargettableEntitiesWithinAABB(Level world, LivingEntity attacker) {
        return TargetSelector.getTargettableEntitiesWithinAABB(world, attacker, TargetSelector.getResolvedAxisAligned(attacker.m_20191_(), attacker.m_20154_(), TargetSelector.getResolvedReach(attacker)));
    }

    public static List<Entity> getTargettableEntitiesWithinAABB(Level world, LivingEntity attacker, AABB aabb) {
        double reach = TargetSelector.getResolvedReach(attacker);
        return TargetSelector.getTargettableEntitiesWithinAABB(world, attacker, aabb, reach);
    }

    public static List<Entity> getTargettableEntitiesWithinAABB(Level world, LivingEntity attacker, AABB aabb, double reach) {
        ArrayList list1 = Lists.newArrayList();
        list1.addAll(TargetSelector.getReflectableEntitiesWithinAABB(attacker));
        list1.addAll(TargetSelector.getExtinguishableEntitiesWithinAABB(attacker));
        list1.addAll(world.m_6443_(LivingEntity.class, aabb.m_82400_(5.0), e -> e.isMultipartEntity()).stream().flatMap(e -> e.isMultipartEntity() ? Stream.of(e.getParts()) : Stream.of(e)).filter(t -> {
            PartEntity part;
            Entity patt6222$temp;
            boolean result = false;
            AttackablePredicate check = new AttackablePredicate();
            if (t instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)t;
                result = check.test(living);
            } else if (t instanceof PartEntity && (patt6222$temp = (part = (PartEntity)t).getParent()) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt6222$temp;
                result = check.test(living) && part.m_20280_((Entity)attacker) < reach * reach;
            }
            return result;
        }).collect(Collectors.toList()));
        TargetingConditions predicate = TargetSelector.getAreaAttackPredicate(reach);
        list1.addAll(world.m_45976_(LivingEntity.class, aabb).stream().flatMap(e -> e.isMultipartEntity() ? Stream.of(e.getParts()) : Stream.of(e)).filter(t -> {
            PartEntity part;
            Entity patt6860$temp;
            boolean result = false;
            if (t instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)t;
                result = predicate.m_26885_(attacker, living);
            } else if (t instanceof PartEntity && (patt6860$temp = (part = (PartEntity)t).getParent()) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt6860$temp;
                result = predicate.m_26885_(attacker, living) && part.m_20280_((Entity)attacker) < reach * reach;
            }
            return result;
        }).collect(Collectors.toList()));
        return list1;
    }

    public static <E extends Entity> List<Entity> getTargettableEntitiesWithinAABB(Level world, double reach, E owner) {
        AABB aabb = owner.m_20191_().m_82400_(reach);
        ArrayList list1 = Lists.newArrayList();
        list1.addAll(world.m_45976_(EnderDragon.class, aabb.m_82400_(5.0)).stream().flatMap(d -> Arrays.stream(d.m_31156_())).filter(e -> e.m_20280_(owner) < reach * reach).collect(Collectors.toList()));
        LivingEntity user = ((IShootable)owner).getShooter() instanceof LivingEntity ? (LivingEntity)((IShootable)owner).getShooter() : null;
        list1.addAll(TargetSelector.getReflectableEntitiesWithinAABB(world, reach, owner));
        TargetingConditions predicate = TargetSelector.getAreaAttackPredicate(0.0);
        list1.addAll(world.m_6443_(LivingEntity.class, aabb, e -> true).stream().filter(t -> predicate.m_26885_(user, t)).collect(Collectors.toList()));
        return list1;
    }

    public static <E extends Entity> List<Entity> getReflectableEntitiesWithinAABB(Level world, double reach, E owner) {
        AABB aabb = owner.m_20191_().m_82400_(reach);
        return Stream.of(world.m_45976_(Projectile.class, aabb).stream().filter(e -> e.m_19749_() == null || e.m_19749_() != ((IShootable)owner).getShooter())).flatMap(s -> s).filter(e -> e.m_20280_(owner) < reach * reach && e != owner).collect(Collectors.toList());
    }

    public static AABB getResolvedAxisAligned(AABB bb, Vec3 dir, double reach) {
        double padding = 1.0;
        bb = dir == Vec3.f_82478_ ? bb.m_82400_(reach * 2.0) : bb.m_82383_(dir.m_82490_(reach * 0.5)).m_82400_(reach);
        bb = bb.m_82400_(1.0);
        return bb;
    }

    public static double getResolvedReach(LivingEntity user) {
        double reach = 4.0;
        AttributeInstance attrib = user.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get());
        if (attrib != null) {
            reach = attrib.m_22135_() - 1.0;
        }
        return reach;
    }

    @SubscribeEvent
    public static void onInputChange(InputCommandEvent event) {
        EnumSet<InputCommand> old = event.getOld();
        EnumSet<InputCommand> current = event.getCurrent();
        ServerPlayer sender = event.getEntity();
        ItemStack stack = sender.m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        if (!(stack.m_41720_() instanceof ItemSlashBlade)) {
            return;
        }
        if (old.contains((Object)InputCommand.M_DOWN) || !current.contains((Object)InputCommand.M_DOWN) || !current.contains((Object)InputCommand.SNEAK)) {
            return;
        }
        stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(s -> {
            Entity tmp = s.getTargetEntity(sender.m_9236_());
            if (tmp == null) {
                return;
            }
            if (!(tmp instanceof LivingEntity)) {
                return;
            }
            LivingEntity target = (LivingEntity)tmp;
            if (target.m_21188_() == sender) {
                return;
            }
            target.m_6703_((LivingEntity)sender);
            if (target.m_9236_() instanceof ServerLevel) {
                ServerLevel sw = (ServerLevel)target.m_9236_();
                sw.m_8624_(sender, (ParticleOptions)ParticleTypes.f_123792_, false, target.m_20185_(), target.m_20186_() + (double)target.m_20192_(), target.m_20189_(), 5, (double)target.m_20205_() * 1.5, (double)target.m_20206_(), (double)target.m_20205_() * 1.5, 0.02);
            }
        });
    }

    public static class AttackablePredicate
    implements Predicate<LivingEntity> {
        @Override
        public boolean test(LivingEntity livingentity) {
            if (!((Boolean)SlashBladeConfig.PVP_ENABLE.get()).booleanValue() && livingentity instanceof Player) {
                return false;
            }
            if (livingentity instanceof ArmorStand) {
                return ((ArmorStand)livingentity).m_31677_();
            }
            if (livingentity.m_19880_().contains(TargetSelector.AttackableTag)) {
                livingentity.m_20137_(TargetSelector.AttackableTag);
                return true;
            }
            if (!((Boolean)SlashBladeConfig.FRIENDLY_ENABLE.get()).booleanValue() && !(livingentity instanceof Enemy)) {
                return false;
            }
            if (livingentity.m_146862_(entity -> entity instanceof Player)) {
                return false;
            }
            if (livingentity.m_142038_()) {
                return true;
            }
            if (livingentity.m_5647_() != null) {
                return true;
            }
            return !livingentity.m_6095_().m_204039_(SlashBladeEntityTypeTagProvider.EntityTypeTags.ATTACKABLE_BLACKLIST);
        }
    }

    public static class SlashBladeTargetingConditions
    extends TargetingConditions {
        public SlashBladeTargetingConditions() {
            super(true);
        }

        public boolean m_26885_(@Nullable LivingEntity attacker, LivingEntity target) {
            boolean isAttackable = false;
            if (!(isAttackable |= TargetSelector.isAttackable((Entity)target.m_21188_(), (Entity)attacker)) && target instanceof Mob) {
                isAttackable |= TargetSelector.isAttackable((Entity)((Mob)target).m_5448_(), (Entity)attacker);
            }
            if (isAttackable) {
                target.m_20049_(TargetSelector.AttackableTag);
            }
            return super.m_26885_(attacker, target);
        }
    }
}

